/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.LoggerNameAwareMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogger
extends AbstractLogger {
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;

    public SLF4JLogger(String name, Logger logger) {
        super(name);
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    public SLF4JLogger(String name, MessageFactory messageFactory, Logger logger) {
        super(name, messageFactory);
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    public void log(org.apache.logging.log4j.Marker marker, String fqcn, Level level, Message data, Throwable t) {
        if (this.locationAwareLogger != null) {
            if (data instanceof LoggerNameAwareMessage) {
                ((LoggerNameAwareMessage)data).setLoggerName(this.getName());
            }
            this.locationAwareLogger.log(this.getMarker(marker), fqcn, this.convertLevel(level), data.getFormattedMessage(), data.getParameters(), t);
        } else {
            switch (level) {
                case DEBUG: {
                    this.logger.debug(this.getMarker(marker), data.getFormattedMessage(), (Object)data.getParameters(), (Object)t);
                    break;
                }
                case TRACE: {
                    this.logger.trace(this.getMarker(marker), data.getFormattedMessage(), (Object)data.getParameters(), (Object)t);
                    break;
                }
                case INFO: {
                    this.logger.info(this.getMarker(marker), data.getFormattedMessage(), (Object)data.getParameters(), (Object)t);
                    break;
                }
                case WARN: {
                    this.logger.warn(this.getMarker(marker), data.getFormattedMessage(), (Object)data.getParameters(), (Object)t);
                    break;
                }
                case ERROR: {
                    this.logger.error(this.getMarker(marker), data.getFormattedMessage(), (Object)data.getParameters(), (Object)t);
                    break;
                }
                default: {
                    this.logger.error(this.getMarker(marker), data.getFormattedMessage(), (Object)data.getParameters(), (Object)t);
                }
            }
        }
    }

    private Marker getMarker(org.apache.logging.log4j.Marker marker) {
        if (marker == null) {
            return null;
        }
        org.apache.logging.log4j.Marker parent = marker.getParent();
        Marker parentMarker = parent == null ? null : this.getMarker(parent);
        Marker slf4jMarker = MarkerFactory.getMarker((String)marker.getName());
        if (parentMarker != null && !slf4jMarker.contains(parentMarker)) {
            slf4jMarker.add(parentMarker);
        }
        return slf4jMarker;
    }

    private int convertLevel(Level level) {
        switch (level) {
            case DEBUG: {
                return 10;
            }
            case TRACE: {
                return 0;
            }
            case INFO: {
                return 20;
            }
            case WARN: {
                return 30;
            }
            case ERROR: {
                return 40;
            }
        }
        return 40;
    }

    protected boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String data) {
        return this.isEnabledFor(level, marker);
    }

    protected boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    protected boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String data, Object ... p1) {
        return this.isEnabledFor(level, marker);
    }

    protected boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, Object data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    protected boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, Message data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    private boolean isEnabledFor(Level level, org.apache.logging.log4j.Marker marker) {
        Marker slf4jMarker = this.getMarker(marker);
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled(slf4jMarker);
            }
            case TRACE: {
                return this.logger.isTraceEnabled(slf4jMarker);
            }
            case INFO: {
                return this.logger.isInfoEnabled(slf4jMarker);
            }
            case WARN: {
                return this.logger.isWarnEnabled(slf4jMarker);
            }
            case ERROR: {
                return this.logger.isErrorEnabled(slf4jMarker);
            }
        }
        return this.logger.isErrorEnabled(slf4jMarker);
    }

    public Logger getLogger() {
        return this.locationAwareLogger != null ? this.locationAwareLogger : this.logger;
    }
}

